#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_HL7InterfaceConfig  : BaseTest 
	{	
		private HL7InterfaceConfig _testConfig;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			_testConfig = (HL7InterfaceConfig)HL7InterfaceConfig.GetHL7InterfaceConfigs()[0];
		}

		[TearDown]
		protected void TearDown()
		{
			_testConfig = null;
		}

		[Test]
		public void GetHl7InterfaceConfigs_Pass()
		{
			Assert.IsTrue( HL7InterfaceConfig.GetHL7InterfaceConfigs().Count > 0 );
		}

		[Test]
		 [Ignore( StandardIgnoreReasons.ParameterlessMethod )]
		public void GetHl7InterfaceConfigs_Fail(){}

		[Test]
		[ExpectedException(typeof(NotSupportedException))]
		public void LoadDataRowFromThis_Pass()
		{
			_testConfig.LoadDataRowFromThis( null );
		}

		[Test]
		[ExpectedException(typeof(NotSupportedException))]
		public void LoadDataRowFromThis_Fail() 
		{
			_testConfig.LoadDataRowFromThis( null );
		}

		[Test]
		public void Interface_Pass()
		{
			Assert.IsNotNull( _testConfig.Interface );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void Interface_Fail(){}

		[Test]
		public void Save_Pass()
		{
			int _oldValue = _testConfig.Interface.AckTimeout;
			
			_testConfig.Interface.AckTimeout = _oldValue + 1;
			_testConfig.Interface.InterfaceAdministratorEmail = PII               ";
			_testConfig.Interface.VbecsPortNumber = PORT redacted;
			_testConfig.Interface.VbecsIPAddress = System.Net.IPAddress.Any;
			_testConfig.Interface.InterfaceIPAddress = System.Net.IPAddress.Any;
			_testConfig.Interface.InterfacePortNumber = PORT redacted;
			_testConfig.Interface.InterfaceFacilityId = UnitTestConfig.TestDivisionCode;
			_testConfig.Save();

			DAL.HL7AL.HL7Interface _testInterface = new DAL.HL7AL.HL7Interface( _testConfig.Interface.InterfaceName );

			try
			{
				Assert.AreEqual( _testConfig.Interface.AckTimeout, _testInterface.AckTimeout );
			}
			finally
			{
				_testConfig.Interface.AckTimeout = _oldValue;
				_testConfig.Save();
			}
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void Save_Fail()
		{
			_testConfig.Interface.AckTimeout = -1;
			_testConfig.Save();
		}

		[Test]
		public void ReloadInterfaceFromDb_Pass()
		{
			int _controlValue = _testConfig.Interface.AckTimeout;
			
			_testConfig.Interface.AckTimeout += 10;

			_testConfig.ReloadInterfaceFromDb();

			Assert.AreEqual( _controlValue, _testConfig.Interface.AckTimeout );
		}
		
		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void ReloadInterfaceFromDb_Fail() {}
	}
}
#endif
